<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  $invoice_number = $_POST['invoice_number'];
  $customer = $_POST['customer'];
  $contact = $_POST['contact'];
  $date = date('Y-m-d');
  $items = json_decode($_POST['items'], true);
  $discount = (float)$_POST['discount'];
  $show_total = isset($_POST['show_total']);

  ob_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Quotation</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
  html, body {
    height: 100%;
  }
  body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 40px;
    display: flex;
    flex-direction: column;
    min-height: 100vh;
  }
  .logo {
    width: 180px;
    display: block;
  }
  .company-info {
    font-size: 0.9em;
    color: #333;
    margin-top: 5px;
  }
  .header-line, .footer-line {
    border-top: 2px solid #ddd;
    margin: 20px 0;
  }
  .invoice-title {
    font-size: 2em;
    color: rgba(0, 91, 170, 0.62);
    font-weight: bold;
  }
  .footer-bar {
    font-size: 0.9em;
    color: #555;
    display: flex;
    justify-content: space-between;
    padding-top: 10px;
  }
  .totals {
    margin-left: auto;
    width: 250px;
  }
  .content {
    flex: 1 0 auto;
  }
  </style>
</head>
<body>
  <div>
    <div class="d-flex justify-content-between align-items-center">
      <div>
        <img src="logo.png" alt="Logo" class="logo">
      </div>
      <div class="invoice-title">QUOTATION</div>
    </div>

    <div class="header-line"></div>

    <div class="row">
      <div class="col-md-6">
        <p><strong>Quotation To:</strong><br>
         <label>Name: </label><?= htmlspecialchars($customer) ?><br>
         <label>Contact: </label><?= htmlspecialchars($contact) ?></p>
      </div>
      <div class="col-md-6 text-end">
        <p><strong>Date:</strong> <?= htmlspecialchars($date) ?><br>
        <strong>Quotation No:</strong> <?= htmlspecialchars($invoice_number) ?></p>
      </div>
    </div>

    <table class="table table-bordered mt-4">
      <thead class="table-light">
        <tr>
          <th>Qty</th>
          <th>Description</th>
          <th>Warranty</th>
          <th class="text-end">Price</th>
          <th class="text-end">Total</th>
        </tr>
      </thead>
      <tbody>
        <?php 
          $subtotal = 0;
          foreach ($items as $item):
            $qty = floatval($item['qty']);
            $price = floatval($item['price']);
            $amount = $qty * $price;
            $subtotal += $amount;
            $warranty_value = str_pad($item['warranty'], 2, '0', STR_PAD_LEFT);
            $warranty_text = $item['warranty_unit'] === 'months' ? "$warranty_value Months" : "$warranty_value Days";
        ?>
        <tr>
          <td><?= $qty ?></td>
          <td><?= htmlspecialchars($item['desc']) ?></td>
          <td><?= htmlspecialchars($warranty_text) ?></td>
          <td class="text-end"><?= number_format($price, 2) ?></td>
          <td class="text-end"><?= number_format($amount, 2) ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <?php if ($show_total && $subtotal > 0): ?>
    <table class="table table-borderless mt-5" style="width: 250px; margin-left: auto;">
      <tbody>
        <tr>
          <td class="text-end"><strong>Sub Total:</strong></td>
          <td class="text-end">LKR <?= number_format($subtotal, 2) ?></td>
        </tr>
        <?php if ($discount > 0): ?>
        <tr>
          <td class="text-end"><strong>Discount:</strong></td>
          <td class="text-end">LKR <?= number_format($discount, 2) ?></td>
        </tr>
        <?php endif; ?>
        <tr>
          <td class="text-end"><strong>Grand Total:</strong></td>
          <td class="text-end"><strong>LKR <?= number_format($subtotal - $discount, 2) ?></strong></td>
        </tr>
      </tbody>
    </table>
    <?php endif; ?>

    <!-- Payment Methods and validity note -->
    <div class="mt-4">
      <p><strong>Payment Methods:</strong> Bank / Credit Card / Cheque / Cash</p>
      <p>This quotation is valid for 14 days. Full payment upon delivery unless agreed.</p>
    </div>

  </div>

  <div class="footer mt-auto">
    <div class="footer-line"></div>
    <div class="footer-bar">
      <span>📞 076-4328756</span>
      <span>📧 info@transteklanka.com</span>
      <span>📍 No. 70/14, D.S.Senanayake Rd, Colombo 08</span>
    </div>
  </div>
</body>
</html>
<?php
  $output = ob_get_clean();
  file_put_contents("quotation_output.html", $output);
  header("Location: quotation_output.html");
  exit;
}
?>

<!-- ========== FORM PAGE ========== -->
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Create Quotation</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
  <h1 class="mb-4 text-primary">Create Quotation</h1>
  <form method="post" onsubmit="return prepareItems()">
    <div class="mb-3">
      <label class="form-label">Quotation Number</label>
      <input type="text" name="invoice_number" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Customer Name</label>
      <input type="text" name="customer" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Contact Number</label>
      <input type="text" name="contact" class="form-control" required>
    </div>

    <h4 class="mt-4">Items</h4>
    <div id="items" class="mb-3"></div>
    <button type="button" class="btn btn-secondary mb-3" onclick="addItem()">Add Item</button>

    <div class="mb-3">
      <label class="form-label">Discount (LKR)</label>
      <input type="number" name="discount" class="form-control" value="0" step="any">
    </div>

    <div class="form-check mb-3">
      <input type="checkbox" class="form-check-input" name="show_total" checked>
      <label class="form-check-label">Include Total in Output</label>
    </div>

    <input type="hidden" name="items" id="itemsField">
    <button type="submit" class="btn btn-primary">Generate Quotation</button>
  </form>

<script>
  let items = [];

  function addItem() {
    const item = { qty: 1, desc: '', price: 0, warranty: 0, warranty_unit: 'months' };
    const index = items.length;
    items.push(item);

    const div = document.createElement('div');
    div.classList.add('row', 'g-3', 'align-items-center', 'mb-3');
    div.setAttribute('data-index', index);

    div.innerHTML = `
      <div class="col-md-2">
        <input type="number" class="form-control" value="1" required placeholder="Qty">
      </div>
      <div class="col-md-3">
        <input type="text" class="form-control" placeholder="Description" required>
      </div>
      <div class="col-md-2">
        <input type="number" class="form-control" value="" required placeholder="Price">
      </div>
      <div class="col-md-2">
        <input type="number" class="form-control" value="" required placeholder="Warranty">
      </div>
      <div class="col-md-2">
        <select class="form-select">
          <option value="months">Months</option>
          <option value="days">Days</option>
        </select>
      </div>
      <div class="col-md-1">
        <button type="button" class="btn btn-danger btn-sm remove-btn">X</button>
      </div>
    `;

    const inputs = div.querySelectorAll('input');
    const select = div.querySelector('select');

    inputs[0].addEventListener('input', e => item.qty = parseFloat(e.target.value));
    inputs[1].addEventListener('input', e => item.desc = e.target.value);
    inputs[2].addEventListener('input', e => item.price = parseFloat(e.target.value));
    inputs[3].addEventListener('input', e => item.warranty = e.target.value);
    select.addEventListener('change', e => item.warranty_unit = e.target.value);

    div.querySelector('.remove-btn').addEventListener('click', () => {
      items[index] = null;
      div.remove();
    });

    document.getElementById('items').appendChild(div);
  }

  function prepareItems() {
    const cleanedItems = items.filter(item => item !== null);
    document.getElementById('itemsField').value = JSON.stringify(cleanedItems);
    return true;
  }
</script>
</body>
</html>
